<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_takwim', function (Blueprint $table) {
            $table->string('penyelenggara', 255)->nullable()->after('tanggal_selesai');
            $table->unsignedBigInteger('koordinator_anggota_id')->nullable()->after('penyelenggara');
            
            $table->foreign('koordinator_anggota_id')->references('id')->on('tbl_anggota')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_takwim', function (Blueprint $table) {
            $table->dropForeign(['koordinator_anggota_id']);
            $table->dropColumn(['penyelenggara', 'koordinator_anggota_id']);
        });
    }
};
