<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('anggota_aktivitas_luar', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('anggota_id');
            $table->unsignedBigInteger('aktivitas_luar_id');
            $table->timestamps();
            
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            $table->foreign('aktivitas_luar_id')->references('id')->on('aktivitas_luars')->onDelete('cascade');
            
            $table->unique(['anggota_id', 'aktivitas_luar_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('anggota_aktivitas_luar');
    }
};
