<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Tambah kolom upa_id
            $table->unsignedBigInteger('upa_id')->nullable()->after('ref_grup_upa_id');
            
            // Tambah foreign key constraint
            $table->foreign('upa_id')->references('upa_id')->on('tbl_upa')->onDelete('set null');
            
            // Tambah index untuk performance
            $table->index('upa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['upa_id']);
            
            // Drop column
            $table->dropColumn('upa_id');
        });
    }
};
