<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabel Provinsi
        Schema::create('ref_provinsi', function (Blueprint $table) {
            $table->id();
            $table->string('kode_provinsi', 10)->unique();
            $table->string('nama_provinsi', 100);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Tabel Kota/Kabupaten
        Schema::create('ref_kota', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kota', 10)->unique();
            $table->string('nama_kota', 100);
            $table->unsignedBigInteger('provinsi_id');
            $table->enum('tipe', ['Kota', 'Kabupaten']);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->foreign('provinsi_id')->references('id')->on('ref_provinsi')->onDelete('cascade');
            $table->index('provinsi_id');
        });

        // Tabel Kecamatan
        Schema::create('ref_kecamatan', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kecamatan', 10)->unique();
            $table->string('nama_kecamatan', 100);
            $table->unsignedBigInteger('kota_id');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->foreign('kota_id')->references('id')->on('ref_kota')->onDelete('cascade');
            $table->index('kota_id');
        });

        // Tabel Kelurahan/Desa
        Schema::create('ref_kelurahan', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kelurahan', 10)->unique();
            $table->string('nama_kelurahan', 100);
            $table->unsignedBigInteger('kecamatan_id');
            $table->enum('tipe', ['Kelurahan', 'Desa']);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->foreign('kecamatan_id')->references('id')->on('ref_kecamatan')->onDelete('cascade');
            $table->index('kecamatan_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ref_kelurahan');
        Schema::dropIfExists('ref_kecamatan');
        Schema::dropIfExists('ref_kota');
        Schema::dropIfExists('ref_provinsi');
    }
};
