<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_absensi_kegiatan', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('kegiatan_id');
            $table->unsignedBigInteger('anggota_id');
            $table->datetime('waktu_checkin');
            $table->enum('status', ['hadir', 'tidak_hadir', 'izin'])->default('hadir');
            $table->text('keterangan')->nullable();
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('kegiatan_id')->references('id')->on('tbl_kegiatan')->onDelete('cascade');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            
            // Indexes
            $table->index(['kegiatan_id', 'anggota_id']);
            $table->index('waktu_checkin');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_absensi_kegiatan');
    }
};
