<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_upa', function (Blueprint $table) {
            $table->unsignedBigInteger('dpc_id')->nullable()->after('status');
            $table->foreign('dpc_id')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_upa', function (Blueprint $table) {
            $table->dropForeign(['dpc_id']);
            $table->dropColumn('dpc_id');
        });
    }
};
