<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_dpc', function (Blueprint $table) {
            $table->unsignedBigInteger('dpd_id')->nullable()->after('is_active');
            $table->foreign('dpd_id')->references('dpd_id')->on('tbl_dpd')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_dpc', function (Blueprint $table) {
            $table->dropForeign(['dpd_id']);
            $table->dropColumn('dpd_id');
        });
    }
};
