<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Index untuk pencarian
            $table->index(['nama_lengkap'], 'idx_anggota_nama');
            $table->index(['nomor_identitas_anggota'], 'idx_anggota_nia');
            $table->index(['email'], 'idx_anggota_email');
            
            // Index untuk filter
            $table->index(['status_keanggotaan'], 'idx_anggota_status');
            $table->index(['ref_jenjang_id'], 'idx_anggota_jenjang');
            $table->index(['provinsi'], 'idx_anggota_provinsi');
            $table->index(['dpc_id'], 'idx_anggota_dpc');
            $table->index(['dpd_id'], 'idx_anggota_dpd');
            
            // Composite index untuk query yang sering digunakan
            $table->index(['status_keanggotaan', 'ref_jenjang_id'], 'idx_anggota_status_jenjang');
            $table->index(['created_at'], 'idx_anggota_created_at');
            
            // Index untuk foreign keys
            $table->index(['ref_grup_upa_id'], 'idx_anggota_grup_upa');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropIndex('idx_anggota_nama');
            $table->dropIndex('idx_anggota_nia');
            $table->dropIndex('idx_anggota_email');
            $table->dropIndex('idx_anggota_status');
            $table->dropIndex('idx_anggota_jenjang');
            $table->dropIndex('idx_anggota_provinsi');
            $table->dropIndex('idx_anggota_dpc');
            $table->dropIndex('idx_anggota_dpd');
            $table->dropIndex('idx_anggota_status_jenjang');
            $table->dropIndex('idx_anggota_created_at');
            $table->dropIndex('idx_anggota_grup_upa');
        });
    }
};
