<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->unsignedBigInteger('dpc_id')->nullable()->after('ref_grup_upa_id');
            $table->unsignedBigInteger('dpd_id')->nullable()->after('dpc_id');
            
            $table->foreign('dpc_id')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
            $table->foreign('dpd_id')->references('dpd_id')->on('tbl_dpd')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropForeign(['dpc_id']);
            $table->dropForeign(['dpd_id']);
            $table->dropColumn(['dpc_id', 'dpd_id']);
        });
    }
};
