<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_kegiatan', function (Blueprint $table) {
            $table->unsignedBigInteger('pic_anggota_id')->nullable()->after('pic_id');
            $table->foreign('pic_anggota_id')->references('id')->on('tbl_anggota')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_kegiatan', function (Blueprint $table) {
            $table->dropForeign(['pic_anggota_id']);
            $table->dropColumn('pic_anggota_id');
        });
    }
};