<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_kegiatan', function (Blueprint $table) {
            $table->unsignedBigInteger('ref_jenis_kegiatan_id')->nullable()->after('tempat');
            $table->foreign('ref_jenis_kegiatan_id')->references('ref_jenis_kegiatan_id')->on('tbl_ref_jenis_kegiatan')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_kegiatan', function (Blueprint $table) {
            $table->dropForeign(['ref_jenis_kegiatan_id']);
            $table->dropColumn('ref_jenis_kegiatan_id');
        });
    }
};