<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Hapus index terlebih dahulu
            $table->dropIndex(['jenjang_anggota']);
            
            // Hapus kolom jenjang_anggota
            $table->dropColumn('jenjang_anggota');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Tambahkan kembali kolom jenjang_anggota
            $table->string('jenjang_anggota')->after('email');
            
            // Tambahkan kembali index
            $table->index('jenjang_anggota');
        });
    }
};