<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_ref_jenis_kegiatan', function (Blueprint $table) {
            $table->id('ref_jenis_kegiatan_id');
            $table->string('kode_jenis_kegiatan', 20)->unique();
            $table->string('nama_jenis_kegiatan', 255);
            $table->text('deskripsi')->nullable();
            $table->string('kategori', 100)->nullable();
            $table->integer('durasi_standar')->nullable()->comment('Durasi standar dalam menit');
            $table->boolean('is_active')->default(true);
            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_ref_jenis_kegiatan');
    }
};
