<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('tbl_upa_pembimbing');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recreate table if needed
        Schema::create('tbl_upa_pembimbing', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('upa_id');
            $table->unsignedBigInteger('anggota_id');
            $table->enum('jabatan', ['Ketua', 'Wakil Ketua', 'Sekretaris', 'Bendahara', 'Anggota'])->default('Anggota');
            $table->date('tanggal_mulai')->nullable();
            $table->date('tanggal_selesai')->nullable();
            $table->enum('status', ['Aktif', 'Tidak Aktif'])->default('Aktif');
            $table->text('catatan')->nullable();
            $table->timestamps();
            
            $table->foreign('upa_id')->references('upa_id')->on('tbl_upa')->onDelete('cascade');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            $table->unique(['upa_id', 'anggota_id']);
        });
    }
};
