<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_upa', function (Blueprint $table) {
            $table->id('upa_id');
            $table->string('kode_upa', 50)->unique();
            $table->string('nama_upa', 255);
            $table->text('deskripsi')->nullable();
            $table->string('alamat', 500)->nullable();
            $table->string('kota', 100)->nullable();
            $table->string('provinsi', 100)->nullable();
            $table->string('kode_pos', 10)->nullable();
            $table->string('no_telepon', 20)->nullable();
            $table->string('email', 100)->nullable();
            $table->date('tanggal_berdiri')->nullable();
            $table->enum('status', ['Aktif', 'Tidak Aktif', 'Dibubarkan'])->default('Aktif');
            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_upa');
    }
};
