<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('tbl_anggota', 'ref_grup_upa_id')) {
            Schema::table('tbl_anggota', function (Blueprint $table) {
                $table->unsignedBigInteger('ref_grup_upa_id')->nullable()->after('ref_jenjang_id');
                $table->foreign('ref_grup_upa_id')->references('ref_grup_upa_id')->on('tbl_ref_grup_upa')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropForeign(['ref_grup_upa_id']);
            $table->dropColumn('ref_grup_upa_id');
        });
    }
};
