<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_anggota_keahlian', function (Blueprint $table) {
            $table->id();
            $table->foreignId('anggota_id')->constrained('tbl_anggota')->onDelete('cascade');
            $table->unsignedBigInteger('ref_keahlian_id');
            $table->foreign('ref_keahlian_id')->references('ref_keahlian_id')->on('tbl_ref_keahlian')->onDelete('cascade');
            $table->timestamps();
            
            // Unique constraint untuk mencegah duplikasi
            $table->unique(['anggota_id', 'ref_keahlian_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_anggota_keahlian');
    }
};
