<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_penilaian_peserta_takwim', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peserta_takwim_id');
            $table->unsignedBigInteger('penilai_id'); // User yang melakukan penilaian
            $table->date('tanggal_penilaian');
            
            // 7 Indikator Penilaian (1 = Ya, 0 = Tidak)
            $table->boolean('indikator_1')->default(false); // Pemahaman keagamaan
            $table->boolean('indikator_2')->default(false); // Keluarga dakwah
            $table->boolean('indikator_3')->default(false); // Kontribusi struktur partai
            $table->boolean('indikator_4')->default(false); // Pembinaan rutin
            $table->boolean('indikator_5')->default(false); // Setia pada kebijakan partai
            $table->boolean('indikator_6')->default(false); // Counter opini negatif
            $table->boolean('indikator_7')->default(false); // Konsensus Dasar Kebangsaan
            
            // Hasil Penilaian
            $table->integer('total_skor')->default(0); // Total skor (0-7)
            $table->enum('status_kelulusan', ['Lulus', 'Tidak Lulus'])->default('Tidak Lulus');
            $table->text('catatan_penilaian')->nullable();
            $table->text('rekomendasi')->nullable();
            
            $table->timestamps();
            
            // Foreign Keys
            $table->foreign('peserta_takwim_id')->references('id')->on('tbl_peserta_takwim')->onDelete('cascade');
            $table->foreign('penilai_id')->references('id')->on('users')->onDelete('cascade');
            
            // Unique constraint - satu peserta hanya bisa dinilai sekali per penilai
            $table->unique(['peserta_takwim_id', 'penilai_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_penilaian_peserta_takwim');
    }
};