<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->unsignedBigInteger('ref_jenjang_id')->nullable()->after('jenjang_anggota');
            $table->foreign('ref_jenjang_id')->references('ref_jenjang_id')->on('tbl_ref_jenjang')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropForeign(['ref_jenjang_id']);
            $table->dropColumn('ref_jenjang_id');
        });
    }
};
