<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Tambahkan kolom untuk data terenkripsi
            $table->text('nomor_identitas_anggota_encrypted')->nullable()->after('nomor_identitas_anggota');
            $table->text('alamat_jalan_encrypted')->nullable()->after('alamat_jalan');
            $table->text('rt_encrypted')->nullable()->after('rt');
            $table->text('rw_encrypted')->nullable()->after('rw');
            $table->text('kelurahan_encrypted')->nullable()->after('kelurahan');
            $table->text('no_telepon_encrypted')->nullable()->after('no_telepon');
            $table->text('email_encrypted')->nullable()->after('email');
            $table->text('penghasilan_per_bulan_encrypted')->nullable()->after('penghasilan_per_bulan');
            $table->text('nomor_identitas_pasangan_encrypted')->nullable()->after('penghasilan_per_bulan_encrypted');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropColumn([
                'nomor_identitas_anggota_encrypted',
                'alamat_jalan_encrypted',
                'rt_encrypted',
                'rw_encrypted',
                'kelurahan_encrypted',
                'no_telepon_encrypted',
                'email_encrypted',
                'penghasilan_per_bulan_encrypted',
                'nomor_identitas_pasangan_encrypted'
            ]);
        });
    }
};
