<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        Schema::create('tbl_kegiatan_partisipan', function (Blueprint $table) {
            $table->id();
            $table->foreignId('kegiatan_id')->constrained('tbl_kegiatan')->onDelete('cascade');
            $table->foreignId('anggota_id')->constrained('tbl_anggota')->onDelete('cascade');
            $table->enum('status_partisipasi', ['Wajib', 'Opsional', 'Undangan'])->default('Wajib');
            $table->enum('status_kehadiran', ['Belum Konfirmasi', 'Hadir', 'Tidak Hadir', 'Izin'])->default('Belum Konfirmasi');
            $table->text('keterangan')->nullable();
            $table->timestamp('waktu_konfirmasi')->nullable();
            $table->timestamps();
            
            $table->unique(['kegiatan_id', 'anggota_id']);
            $table->index('status_kehadiran');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_kegiatan_partisipan');
    }
};
