<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
   {
        if (Schema::hasTable('tbl_kegiatan')) {
            return;
        }
        Schema::create('tbl_kegiatan', function (Blueprint $table) {
            $table->id();
            $table->string('nama_kegiatan');
            $table->text('deskripsi')->nullable();
            $table->date('tanggal_kegiatan');
            $table->time('waktu_mulai');
            $table->time('waktu_selesai')->nullable();
            $table->text('tempat');
            $table->enum('jenis_kegiatan', ['Mabit', 'Rapat', 'Pelatihan', 'Sosialisasi', 'Lainnya']);
            $table->enum('status_kegiatan', ['Direncanakan', 'Berlangsung', 'Selesai', 'Dibatalkan'])->default('Direncanakan');
            $table->integer('target_peserta')->nullable();
            $table->text('catatan')->nullable();
            $table->foreignId('pic_id')->nullable()->constrained('users'); // Person in Charge
            $table->timestamps();
            
            $table->index('tanggal_kegiatan');
            $table->index('status_kegiatan');
            $table->index('jenis_kegiatan');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_kegiatan');
    }
};
