<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (Schema::hasTable('tbl_mutasi')) {
            return;
        }
        Schema::create('tbl_mutasi', function (Blueprint $table) {
            $table->id();
            
            // Info Umum
            $table->string('nomor_sk')->nullable();
            $table->foreignId('anggota_id')->constrained('tbl_anggota')->onDelete('cascade');
            $table->enum('jenis_mutasi', ['Keluar', 'Penempatan', 'Rekomposisi']);
            $table->date('tanggal_mutasi');
            $table->enum('status_mutasi', ['Pending', 'Disetujui', 'Ditolak'])->default('Pending');
            
            // Struktur Organisasi
            $table->foreignId('struktur_dari')->nullable()->constrained('tbl_struktur_organisasi');
            $table->foreignId('struktur_ke')->nullable()->constrained('tbl_struktur_organisasi');
            $table->string('jenjang_dari')->nullable();
            $table->string('jenjang_ke')->nullable();
            
            // Field untuk Surat Mutasi Keluar
            $table->text('alamat_tujuan')->nullable();
            $table->text('alasan_mutasi')->nullable();
            
            // Field untuk Surat Penempatan UPA
            $table->string('kode_upa')->nullable();
            $table->string('pembimbing_baru_nama')->nullable();
            $table->string('pembimbing_baru_telepon')->nullable();
            $table->string('pembimbing_lama_nama')->nullable();
            $table->string('pembimbing_lama_telepon')->nullable();
            $table->date('tahun_pelantikan')->nullable();
            
            // Field untuk Surat Rekomposisi (JSON array)
            $table->json('komposisi_anggota')->nullable(); // Array anggota dalam grup
            $table->text('alasan_rekomposisi')->nullable();
            
            // Field Umum
            $table->text('catatan')->nullable();
            
            // Approval Info
            $table->foreignId('disetujui_oleh')->nullable()->constrained('users');
            $table->timestamp('tanggal_sk')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index('nomor_sk');
            $table->index('jenis_mutasi');
            $table->index('status_mutasi');
            $table->index('tanggal_mutasi');
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_mutasi');
    }
};
