<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabel Peserta Takwim
        Schema::create('tbl_peserta_takwim', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('takwim_id');
            $table->unsignedBigInteger('anggota_id');
            $table->date('tanggal_bergabung');
            $table->date('tanggal_keluar')->nullable();
            $table->text('catatan')->nullable();
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('takwim_id')->references('id')->on('tbl_takwim')
                  ->onDelete('cascade');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')
                  ->onDelete('cascade');
            
            // Unique constraint
            $table->unique(['takwim_id', 'anggota_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_peserta_takwim');
    }
};
