<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabel Program Takwim (untuk kegiatan berkelanjutan)
        Schema::create('tbl_takwim', function (Blueprint $table) {
            $table->id();
            $table->string('nama_takwim');
            $table->text('deskripsi')->nullable();
            $table->date('tanggal_mulai');
            $table->date('tanggal_selesai')->nullable();
            $table->unsignedBigInteger('struktur_penyelenggara_id')->nullable();
            $table->string('koordinator');
            $table->text('evaluasi')->nullable();
            $table->text('catatan_berkelanjutan')->nullable();
            $table->enum('status_takwim', ['Aktif', 'Selesai', 'Ditunda'])->default('Aktif');
            $table->timestamps();
            
            // Foreign key
            $table->foreign('struktur_penyelenggara_id')
                  ->references('id')->on('tbl_struktur_organisasi')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_takwim');
    }
};
