<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       // Tabel Absensi Kegiatan
        Schema::create('tbl_absensi_kegiatan', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('kegiatan_id');
            $table->unsignedBigInteger('anggota_id');
            $table->enum('status_kehadiran', ['Hadir', 'Tidak Hadir', 'Izin', 'Sakit']);
            $table->datetime('waktu_absen')->nullable(); // Waktu saat absen
            $table->text('catatan_kehadiran')->nullable();
            $table->string('metode_absen')->default('Manual'); // Manual, QR Code, etc
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('kegiatan_id')->references('id')->on('tbl_kegiatan')
                  ->onDelete('cascade');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')
                  ->onDelete('cascade');
            
            // Unique constraint - satu anggota hanya bisa absen sekali per kegiatan
            $table->unique(['kegiatan_id', 'anggota_id']);
            
            // Indexes
            $table->index(['kegiatan_id', 'status_kehadiran']);
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_absensi_kegiatan');
    }
};
