<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // Tabel Kegiatan
        Schema::create('tbl_kegiatan', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kegiatan')->unique();
            $table->string('nama_kegiatan');
            $table->enum('jenis_kegiatan', ['Mabit', 'Rapat', 'Takwim', 'Lainnya']);
            $table->text('uraian_kegiatan')->nullable();
            $table->datetime('tanggal_mulai');
            $table->datetime('tanggal_selesai');
            $table->string('tempat');
            $table->text('alamat_tempat')->nullable();
            $table->unsignedBigInteger('struktur_penyelenggara_id')->nullable();
            $table->string('pic_kegiatan'); // Person in charge
            $table->text('catatan')->nullable();
            $table->enum('status_kegiatan', ['Planned', 'Ongoing', 'Completed', 'Cancelled'])
                  ->default('Planned');
            $table->timestamps();
            
            // Foreign key
            $table->foreign('struktur_penyelenggara_id')
                  ->references('id')->on('tbl_struktur_organisasi')
                  ->onDelete('set null');
            
            // Indexes
            $table->index('kode_kegiatan');
            $table->index('jenis_kegiatan');
            $table->index('tanggal_mulai');
            $table->index('status_kegiatan');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_kegiatan');
    }
};
