<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
    {
        Schema::create('tbl_mutasi', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('anggota_id');
            $table->enum('jenis_mutasi', [
                'Masuk', 
                'Pindah', 
                'Keluar', 
                'Promosi', 
                'Demosi',
                'Pencupatan',
                'Reaktivasi'
            ]);
            $table->unsignedBigInteger('struktur_dari')->nullable(); // Struktur asal
            $table->unsignedBigInteger('struktur_ke')->nullable();   // Struktur tujuan
            $table->string('jenjang_dari')->nullable();
            $table->string('jenjang_ke')->nullable();
            $table->date('tanggal_mutasi');
            $table->text('alasan_mutasi');
            $table->string('nomor_sk')->nullable(); // Nomor Surat Keputusan
            $table->date('tanggal_sk')->nullable();
            $table->string('disetujui_oleh')->nullable();
            $table->text('catatan')->nullable();
            $table->enum('status_mutasi', ['Pending', 'Disetujui', 'Ditolak'])->default('Pending');
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')
                  ->onDelete('cascade');
            $table->foreign('struktur_dari')->references('id')->on('tbl_struktur_organisasi')
                  ->onDelete('set null');
            $table->foreign('struktur_ke')->references('id')->on('tbl_struktur_organisasi')
                  ->onDelete('set null');
            
            // Indexes
            $table->index('anggota_id');
            $table->index('tanggal_mutasi');
            $table->index('jenis_mutasi');
            $table->index('status_mutasi');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_mutasi');
    }
};
