<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        Schema::create('tbl_anggota', function (Blueprint $table) {
            $table->id();
            $table->string('nomor_identitas_anggota')->unique();
            $table->string('nama_lengkap');
            $table->string('tempat_lahir');
            $table->date('tanggal_lahir');
            $table->enum('jenis_kelamin', ['L', 'P']);
            
            // Alamat
            $table->text('alamat_jalan');
            $table->string('rt', 5);
            $table->string('rw', 5);
            $table->string('kelurahan');
            $table->string('kecamatan');
            $table->string('kota');
            $table->string('provinsi');
            
            $table->string('no_telepon', 15)->nullable();
            $table->string('email')->nullable();
            $table->string('jenjang_anggota');
            $table->date('tanggal_bergabung');
            $table->enum('status_keanggotaan', ['Aktif', 'Tidak Aktif', 'Diberhentikan', 'Pindah'])
                  ->default('Aktif');
            
            $table->decimal('penghasilan_per_bulan', 12, 2)->nullable();
            $table->enum('muzaki_mustahiq', ['Muzaki', 'Mustahiq'])->nullable();
            $table->string('nomor_identitas_pasangan')->nullable();
            $table->text('catatan_profil')->nullable();
            $table->string('foto')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index('nomor_identitas_anggota');
            $table->index('status_keanggotaan');
            $table->index('jenjang_anggota');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_anggota');
    }
};
