<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('tbl_struktur_organisasi', function (Blueprint $table) {
            $table->id();
            $table->string('kode_struktur')->unique();
            $table->string('nama_struktur');
            $table->enum('tipe_struktur', [
                'Provinsi', 
                'Kabupaten/Kota', 
                'Kecamatan', 
                'Cabang', 
                'Grup', 
                'UPA', 
                'Unit Kepanitin',
                'B-Sector'
            ]);
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->string('alamat')->nullable();
            $table->string('penanggung_jawab')->nullable();
            $table->text('deskripsi')->nullable();
            $table->enum('status', ['Aktif', 'Tidak Aktif'])->default('Aktif');
            $table->timestamps();
            
            // Foreign key
            $table->foreign('parent_id')->references('id')->on('tbl_struktur_organisasi')
                  ->onDelete('set null');
            
            // Indexes
            $table->index('kode_struktur');
            $table->index('tipe_struktur');
            $table->index('parent_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_struktur_organisasi');
    }
};
