<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update role enum dengan nilai baru
        // Karena MySQL tidak support alter enum langsung, kita drop dan create ulang
        Schema::table('users', function (Blueprint $table) {
            // Hapus kolom role sementara
            $table->dropColumn('role');
        });

        // Tambah kolom role dengan enum baru
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['admin_sistem', 'superadmin', 'admin_dpc', 'admin_dpd', 'anggota'])
                  ->default('anggota')
                  ->after('email');
        });

        // Migrasi data existing
        // admin -> admin_sistem
        // superadmin -> superadmin (tetap)
        // user -> anggota
        DB::table('users')->where('role', 'admin')->update(['role' => 'admin_sistem']);
        DB::table('users')->where('role', 'user')->update(['role' => 'anggota']);

        // Tambah kolom dpc_id, dpd_id, anggota_id (jika belum ada)
        if (!Schema::hasColumn('users', 'dpc_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->unsignedBigInteger('dpc_id')->nullable()->after('is_active');
            });
        }
        
        if (!Schema::hasColumn('users', 'dpd_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->unsignedBigInteger('dpd_id')->nullable()->after('is_active');
            });
        }
        
        if (!Schema::hasColumn('users', 'anggota_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->unsignedBigInteger('anggota_id')->nullable()->after('is_active');
            });
        }

        // Tambah foreign keys (cek dengan try-catch untuk menghindari error jika sudah ada)
        try {
            DB::statement('ALTER TABLE users ADD CONSTRAINT users_dpc_id_foreign FOREIGN KEY (dpc_id) REFERENCES tbl_dpc(dpc_id) ON DELETE SET NULL');
        } catch (\Exception $e) {
            // Foreign key sudah ada atau error lain, skip
        }
        
        try {
            DB::statement('ALTER TABLE users ADD CONSTRAINT users_dpd_id_foreign FOREIGN KEY (dpd_id) REFERENCES tbl_dpd(dpd_id) ON DELETE SET NULL');
        } catch (\Exception $e) {
            // Foreign key sudah ada atau error lain, skip
        }
        
        try {
            DB::statement('ALTER TABLE users ADD CONSTRAINT users_anggota_id_foreign FOREIGN KEY (anggota_id) REFERENCES tbl_anggota(id) ON DELETE SET NULL');
        } catch (\Exception $e) {
            // Foreign key sudah ada atau error lain, skip
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop foreign keys
            $table->dropForeign(['dpc_id']);
            $table->dropForeign(['dpd_id']);
            $table->dropForeign(['anggota_id']);

            // Drop columns
            $table->dropColumn(['dpc_id', 'dpd_id', 'anggota_id']);
        });

        // Revert role enum
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('role');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['superadmin', 'admin', 'user'])->default('user')->after('email');
        });

        // Revert data migration
        DB::table('users')->where('role', 'admin_sistem')->update(['role' => 'admin']);
        DB::table('users')->where('role', 'anggota')->update(['role' => 'user']);
    }
};

