<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('tbl_kegiatan_partisipan_hierarchical', function (Blueprint $table) {
            $table->id();
            $table->foreignId('kegiatan_id')->constrained('tbl_kegiatan')->onDelete('cascade');
            
            // Hierarchical selection
            $table->foreignId('dpd_id')->nullable()->constrained('tbl_dpd', 'dpd_id')->onDelete('cascade');
            $table->foreignId('dpc_id')->nullable()->constrained('tbl_dpc', 'dpc_id')->onDelete('cascade');
            $table->foreignId('upa_id')->nullable()->constrained('tbl_upa', 'upa_id')->onDelete('cascade');
            $table->foreignId('anggota_id')->nullable()->constrained('tbl_anggota')->onDelete('cascade');
            
            // Selection type: 'dpd', 'dpc', 'upa', 'anggota'
            $table->enum('selection_type', ['dpd', 'dpc', 'upa', 'anggota'])->default('anggota');
            
            // Status partisipasi
            $table->enum('status_partisipasi', ['Wajib', 'Opsional', 'Undangan'])->default('Wajib');
            $table->enum('status_kehadiran', ['Belum Konfirmasi', 'Hadir', 'Tidak Hadir', 'Izin'])->default('Belum Konfirmasi');
            $table->text('keterangan')->nullable();
            $table->timestamp('waktu_konfirmasi')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['kegiatan_id', 'selection_type'], 'idx_kegiatan_selection');
            $table->index(['kegiatan_id', 'dpd_id'], 'idx_kegiatan_dpd');
            $table->index(['kegiatan_id', 'dpc_id'], 'idx_kegiatan_dpc');
            $table->index(['kegiatan_id', 'upa_id'], 'idx_kegiatan_upa');
            $table->index(['kegiatan_id', 'anggota_id'], 'idx_kegiatan_anggota');
            $table->index('status_kehadiran', 'idx_status_kehadiran');
            
            // Unique constraint untuk mencegah duplikasi
            $table->unique(['kegiatan_id', 'dpd_id', 'dpc_id', 'upa_id', 'anggota_id'], 'unique_hierarchical_selection');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_kegiatan_partisipan_hierarchical');
    }
};
