<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if tbl_dpc exists, if not create it
        if (!Schema::hasTable('tbl_dpc')) {
            Schema::create('tbl_dpc', function (Blueprint $table) {
                $table->id('dpc_id');
                $table->string('nama_dpc', 100);
                $table->string('kode_dpc', 10)->unique();
                $table->text('deskripsi')->nullable();
                $table->boolean('is_active')->default(true);
                $table->unsignedBigInteger('dpd_id')->nullable();
                $table->timestamps();
                
                $table->foreign('dpd_id')->references('dpd_id')->on('tbl_dpd')->onDelete('set null');
            });
        } else {
            // If table exists, check and add missing columns
            Schema::table('tbl_dpc', function (Blueprint $table) {
                if (!Schema::hasColumn('tbl_dpc', 'is_active')) {
                    $table->boolean('is_active')->default(true)->after('deskripsi');
                }
                if (!Schema::hasColumn('tbl_dpc', 'dpd_id')) {
                    $table->unsignedBigInteger('dpd_id')->nullable()->after('is_active');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Don't drop the table, just remove the columns we added
        Schema::table('tbl_dpc', function (Blueprint $table) {
            if (Schema::hasColumn('tbl_dpc', 'is_active')) {
                $table->dropColumn('is_active');
            }
            if (Schema::hasColumn('tbl_dpc', 'dpd_id')) {
                $table->dropForeign(['dpd_id']);
                $table->dropColumn('dpd_id');
            }
        });
    }
};


















