<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabel Rekomposisi UPA
        Schema::create('tbl_rekomposisi_upa', function (Blueprint $table) {
            $table->id();
            $table->string('nomor_sk')->unique();
            $table->date('tanggal_sk');
            $table->unsignedBigInteger('dpc_id');
            $table->string('judul_sk');
            $table->text('menimbang_a');
            $table->text('menimbang_b');
            $table->text('menimbang_c');
            $table->text('mengingat_1');
            $table->text('mengingat_2');
            $table->text('mengingat_3');
            $table->text('memperhatikan');
            $table->text('memutuskan');
            $table->text('menetapkan');
            $table->text('pertama');
            $table->text('kedua');
            $table->text('ketiga');
            $table->text('keempat');
            $table->string('ditetapkan_di');
            $table->date('ditetapkan_tanggal');
            $table->string('ketua_nama');
            $table->string('ketua_jabatan');
            $table->enum('status', ['Draft', 'Approved', 'Published'])->default('Draft');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->text('catatan')->nullable();
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('dpc_id')->references('dpc_id')->on('tbl_dpc')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            
            // Indexes
            $table->index('nomor_sk');
            $table->index('dpc_id');
            $table->index('status');
            $table->index('tanggal_sk');
        });

        // Tabel Detail Rekomposisi UPA
        Schema::create('tbl_rekomposisi_upa_detail', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('rekomposisi_id');
            $table->string('kode_upa', 50);
            $table->unsignedBigInteger('pembimbing_baru_id');
            $table->unsignedBigInteger('pembimbing_lama_id')->nullable();
            $table->unsignedBigInteger('anggota_id');
            $table->string('dpr_id', 50)->nullable(); // DPRa
            $table->text('keterangan')->nullable();
            $table->integer('urutan')->default(1);
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('rekomposisi_id')->references('id')->on('tbl_rekomposisi_upa')->onDelete('cascade');
            $table->foreign('pembimbing_baru_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            $table->foreign('pembimbing_lama_id')->references('id')->on('tbl_anggota')->onDelete('set null');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            
            // Indexes
            $table->index('rekomposisi_id');
            $table->index('kode_upa');
            $table->index('pembimbing_baru_id');
            $table->index('anggota_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_rekomposisi_upa_detail');
        Schema::dropIfExists('tbl_rekomposisi_upa');
    }
};


















