<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Laravel Optimization Settings
    |--------------------------------------------------------------------------
    |
    | Konfigurasi untuk optimasi performa Laravel
    |
    */

    // Database optimizations
    'database' => [
        'query_log' => env('DB_QUERY_LOG', false),
        'slow_query_log' => env('DB_SLOW_QUERY_LOG', true),
        'slow_query_threshold' => env('DB_SLOW_QUERY_THRESHOLD', 2000), // milliseconds
    ],

    // Cache optimizations
    'cache' => [
        'default_ttl' => env('CACHE_DEFAULT_TTL', 3600), // 1 hour
        'view_ttl' => env('CACHE_VIEW_TTL', 86400), // 24 hours
        'route_ttl' => env('CACHE_ROUTE_TTL', 86400), // 24 hours
    ],

    // Pagination optimizations
    'pagination' => [
        'default_per_page' => 10,
        'max_per_page' => 50,
    ],

    // View optimizations
    'views' => [
        'compile_views' => env('COMPILE_VIEWS', true),
        'cache_views' => env('CACHE_VIEWS', true),
    ],

    // Asset optimizations
    'assets' => [
        'minify_css' => env('MINIFY_CSS', true),
        'minify_js' => env('MINIFY_JS', true),
        'combine_assets' => env('COMBINE_ASSETS', true),
    ],
];
