<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class YaumiyahActivity extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'target_per_week',
        'unit',
        'is_active',
        'sort_order'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'target_per_week' => 'integer',
        'sort_order' => 'integer'
    ];

    public function records()
    {
        return $this->hasMany(YaumiyahRecord::class);
    }
}
