<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UpaGroupAttendance extends Model
{
    use HasFactory;

    protected $table = 'upa_group_attendances';
    protected $primaryKey = 'attendance_id';

    protected $fillable = [
        'activity_id',
        'anggota_id',
        'status_kehadiran',
        'catatan'
    ];

    // Relasi ke aktivitas UPA
    public function activity()
    {
        return $this->belongsTo(UpaGroupActivity::class, 'activity_id', 'activity_id');
    }

    // Relasi ke anggota
    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id', 'id');
    }

    // Scope untuk kehadiran
    public function scopeHadir($query)
    {
        return $query->where('status_kehadiran', 'Hadir');
    }

    // Scope untuk tidak hadir
    public function scopeTidakHadir($query)
    {
        return $query->where('status_kehadiran', 'Tidak Hadir');
    }
}
