<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UpaGroupActivity extends Model
{
    use HasFactory;

    protected $table = 'upa_group_activities';
    protected $primaryKey = 'activity_id';

    protected $fillable = [
        'kode_upa',
        'nama_pembimbing',
        'tanggal_upa',
        'pekan',
        'waktu_upa',
        'kehadiran_pembimbing',
        'agenda_upa',
        'agenda_notes',
        'status_terlaksana',
        'catatan'
    ];

    protected $casts = [
        'tanggal_upa' => 'date',
        'pekan' => 'integer',
        'waktu_upa' => 'datetime:H:i',
        'kehadiran_pembimbing' => 'boolean',
        'agenda_notes' => 'array',
    ];

    // Relasi ke UPA
    public function upa()
    {
        return $this->belongsTo(Upa::class, 'kode_upa', 'kode_upa');
    }

    // Relasi ke kehadiran anggota
    public function attendances()
    {
        return $this->hasMany(UpaGroupAttendance::class, 'activity_id', 'activity_id');
    }

    // Relasi ke anggota yang hadir
    public function anggotaHadir()
    {
        return $this->hasManyThrough(
            Anggota::class,
            UpaGroupAttendance::class,
            'activity_id',
            'id',
            'activity_id',
            'anggota_id'
        )->where('upa_group_attendances.status_kehadiran', 'Hadir');
    }

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('status_terlaksana', 'Terlaksana');
    }

    // Accessor untuk mendapatkan total kehadiran
    public function getTotalKehadiranAttribute()
    {
        return $this->attendances()->where('status_kehadiran', 'Hadir')->count();
    }

    // Accessor untuk mendapatkan total anggota UPA
    public function getTotalAnggotaAttribute()
    {
        return $this->attendances()->count();
    }
}
