<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Takwim extends Model
{
    use HasFactory;

    protected $table = 'tbl_takwim';

    protected $fillable = [
        'nama_takwim',
        'deskripsi',
        'tanggal_mulai',
        'tanggal_selesai',
        'penyelenggara',
        'struktur_penyelenggara_id',
        'koordinator',
        'koordinator_anggota_id',
        'evaluasi',
        'catatan_berkelanjutan',
        'status_takwim'
    ];

    protected $casts = [
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date'
    ];

    // Relationships
    public function strukturPenyelenggara()
    {
        return $this->belongsTo(StrukturOrganisasi::class, 'struktur_penyelenggara_id');
    }

    public function pesertaTakwim()
    {
        return $this->hasMany(PesertaTakwim::class, 'takwim_id');
    }

    // Scopes
    public function scopeAktif($query)
    {
        return $query->where('status_takwim', 'Aktif');
    }
}