<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RekomposisiUpaDetail extends Model
{
    use HasFactory;

    protected $table = 'tbl_rekomposisi_upa_detail';

    protected $fillable = [
        'rekomposisi_id',
        'kode_upa',
        'pembimbing_baru_id',
        'pembimbing_lama_id',
        'anggota_id',
        'dpr_id',
        'keterangan',
        'urutan'
    ];

    // ===== RELATIONSHIPS =====
    public function rekomposisi()
    {
        return $this->belongsTo(RekomposisiUpa::class, 'rekomposisi_id');
    }

    public function pembimbingBaru()
    {
        return $this->belongsTo(Anggota::class, 'pembimbing_baru_id');
    }

    public function pembimbingLama()
    {
        return $this->belongsTo(Anggota::class, 'pembimbing_lama_id');
    }

    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id');
    }

    // ===== SCOPES =====
    public function scopeByKodeUpa($query, $kodeUpa)
    {
        return $query->where('kode_upa', $kodeUpa);
    }

    public function scopeByPembimbingBaru($query, $pembimbingId)
    {
        return $query->where('pembimbing_baru_id', $pembimbingId);
    }

    // ===== HELPER METHODS =====
    public function getKodeUpaFormattedAttribute()
    {
        return strtoupper($this->kode_upa);
    }

    public function getDprFormattedAttribute()
    {
        return $this->dpr_id ? strtoupper($this->dpr_id) : '-';
    }

    public function getKeteranganFormattedAttribute()
    {
        return $this->keterangan ?: '-';
    }
}


















