<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefKota extends Model
{
    use HasFactory;

    protected $table = 'ref_kota';
    
    protected $fillable = [
        'kode_kota',
        'nama_kota',
        'provinsi_id',
        'tipe',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the provinsi that owns the kota
     */
    public function provinsi()
    {
        return $this->belongsTo(RefProvinsi::class, 'provinsi_id');
    }

    /**
     * Get the kecamatan for the kota
     */
    public function kecamatan()
    {
        return $this->hasMany(RefKecamatan::class, 'kota_id');
    }

    /**
     * Scope for active kota
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
