<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefKelurahan extends Model
{
    use HasFactory;

    protected $table = 'ref_kelurahan';
    
    protected $fillable = [
        'kode_kelurahan',
        'nama_kelurahan',
        'kecamatan_id',
        'tipe',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the kecamatan that owns the kelurahan
     */
    public function kecamatan()
    {
        return $this->belongsTo(RefKecamatan::class, 'kecamatan_id');
    }

    /**
     * Scope for active kelurahan
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
