<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefKecamatan extends Model
{
    use HasFactory;

    protected $table = 'ref_kecamatan';
    
    protected $fillable = [
        'kode_kecamatan',
        'nama_kecamatan',
        'kota_id',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the kota that owns the kecamatan
     */
    public function kota()
    {
        return $this->belongsTo(RefKota::class, 'kota_id');
    }

    /**
     * Get the kelurahan for the kecamatan
     */
    public function kelurahan()
    {
        return $this->hasMany(RefKelurahan::class, 'kecamatan_id');
    }

    /**
     * Scope for active kecamatan
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
