<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefGrupUpa extends Model
{
    use HasFactory;

    protected $table = 'tbl_ref_grup_upa';
    protected $primaryKey = 'ref_grup_upa_id';
    
    protected $fillable = [
        'nama_grup_upa',
        'deskripsi',
        'alamat',
        'koordinator',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Relasi ke anggota
    public function anggota()
    {
        return $this->hasMany(Anggota::class, 'ref_grup_upa_id', 'ref_grup_upa_id');
    }
}
