<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PesertaTakwim extends Model
{
    use HasFactory;

    protected $table = 'tbl_peserta_takwim';

    protected $fillable = [
        'takwim_id',
        'anggota_id',
        'tanggal_bergabung',
        'tanggal_keluar',
        'catatan'
    ];

    protected $casts = [
        'tanggal_bergabung' => 'date',
        'tanggal_keluar' => 'date'
    ];

    // Relationships
    public function takwim()
    {
        return $this->belongsTo(Takwim::class, 'takwim_id');
    }

    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id');
    }

    // Relasi ke PenilaianPesertaTakwim
    public function penilaian()
    {
        return $this->hasMany(PenilaianPesertaTakwim::class, 'peserta_takwim_id');
    }

    // Relasi ke penilaian terbaru
    public function penilaianTerbaru()
    {
        return $this->hasOne(PenilaianPesertaTakwim::class, 'peserta_takwim_id')->latest();
    }
}