<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KegiatanPartisipanHierarchical extends Model
{
    use HasFactory;

    protected $table = 'tbl_kegiatan_partisipan_hierarchical';

    protected $fillable = [
        'kegiatan_id',
        'dpd_id',
        'dpc_id',
        'upa_id',
        'anggota_id',
        'selection_type',
        'status_partisipasi',
        'status_kehadiran',
        'keterangan',
        'waktu_konfirmasi'
    ];

    protected $casts = [
        'waktu_konfirmasi' => 'datetime',
    ];

    // Relationships
    public function kegiatan()
    {
        return $this->belongsTo(Kegiatan::class, 'kegiatan_id');
    }

    public function dpd()
    {
        return $this->belongsTo(Dpd::class, 'dpd_id', 'dpd_id');
    }

    public function dpc()
    {
        return $this->belongsTo(Dpc::class, 'dpc_id', 'dpc_id');
    }

    public function upa()
    {
        return $this->belongsTo(Upa::class, 'upa_id', 'upa_id');
    }

    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id');
    }

    // Scopes
    public function scopeBySelectionType($query, $type)
    {
        return $query->where('selection_type', $type);
    }

    public function scopeByDpd($query, $dpdId)
    {
        return $query->where('dpd_id', $dpdId);
    }

    public function scopeByDpc($query, $dpcId)
    {
        return $query->where('dpc_id', $dpcId);
    }

    public function scopeByUpa($query, $upaId)
    {
        return $query->where('upa_id', $upaId);
    }

    public function scopeByAnggota($query, $anggotaId)
    {
        return $query->where('anggota_id', $anggotaId);
    }

    // Helper methods
    public function getDisplayNameAttribute()
    {
        switch ($this->selection_type) {
            case 'dpd':
                return $this->dpd->nama_dpd ?? 'DPD tidak ditemukan';
            case 'dpc':
                return $this->dpc->nama_dpc ?? 'DPC tidak ditemukan';
            case 'upa':
                return $this->upa->nama_upa ?? 'UPA tidak ditemukan';
            case 'anggota':
                return $this->anggota->nama_lengkap ?? 'Anggota tidak ditemukan';
            default:
                return 'Tidak diketahui';
        }
    }

    public function getHierarchyPathAttribute()
    {
        $path = [];
        
        if ($this->dpd) {
            $path[] = $this->dpd->nama_dpd;
        }
        
        if ($this->dpc) {
            $path[] = $this->dpc->nama_dpc;
        }
        
        if ($this->upa) {
            $path[] = $this->upa->nama_upa;
        }
        
        if ($this->anggota) {
            $path[] = $this->anggota->nama_lengkap;
        }
        
        return implode(' → ', $path);
    }
}
