<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class KegiatanPartisipan extends Model
{
    protected $table = 'tbl_kegiatan_partisipan';

    protected $fillable = [
        'kegiatan_id',
        'anggota_id',
        'status_partisipasi',
        'status_kehadiran',
        'keterangan',
        'waktu_konfirmasi'
    ];

    protected $casts = [
        'waktu_konfirmasi' => 'datetime',
    ];

    // Relationships
    public function kegiatan()
    {
        return $this->belongsTo(Kegiatan::class, 'kegiatan_id');
    }

    public function anggota()
    {
        return $this->belongsTo(Anggota::class, 'anggota_id');
    }

    // Accessors
    public function getStatusPartisipasiBadgeAttribute()
    {
        $badges = [
            'Wajib' => 'danger',
            'Opsional' => 'primary',
            'Undangan' => 'info'
        ];
        
        return $badges[$this->status_partisipasi] ?? 'secondary';
    }

    public function getStatusKehadiranBadgeAttribute()
    {
        $badges = [
            'Belum Konfirmasi' => 'secondary',
            'Hadir' => 'success',
            'Tidak Hadir' => 'danger',
            'Izin' => 'warning'
        ];
        
        return $badges[$this->status_kehadiran] ?? 'secondary';
    }
}