<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JenisKegiatan extends Model
{
    use HasFactory;

    protected $table = 'tbl_ref_jenis_kegiatan';
    protected $primaryKey = 'ref_jenis_kegiatan_id';

    protected $fillable = [
        'kode_jenis_kegiatan',
        'nama_jenis_kegiatan',
        'deskripsi',
        'kategori',
        'durasi_standar',
        'is_active',
        'catatan'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'durasi_standar' => 'integer'
    ];

    // Scope untuk data aktif
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Accessor untuk format durasi
    public function getDurasiFormattedAttribute()
    {
        if (!$this->durasi_standar) {
            return '-';
        }

        $jam = floor($this->durasi_standar / 60);
        $menit = $this->durasi_standar % 60;

        if ($jam > 0 && $menit > 0) {
            return "{$jam} jam {$menit} menit";
        } elseif ($jam > 0) {
            return "{$jam} jam";
        } else {
            return "{$menit} menit";
        }
    }
}
