<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CacheHeaders
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Set cache headers untuk static assets
        if ($request->is('css/*') || $request->is('js/*') || $request->is('images/*')) {
            $response->headers->set('Cache-Control', 'public, max-age=31536000'); // 1 year
            $response->headers->set('Expires', gmdate('D, d M Y H:i:s', time() + 31536000) . ' GMT');
        }
        
        // Set cache headers untuk API responses
        if ($request->is('api/*')) {
            $response->headers->set('Cache-Control', 'public, max-age=300'); // 5 minutes
        }
        
        // Set cache headers untuk dashboard
        if ($request->is('dashboard') || $request->is('statistik')) {
            $response->headers->set('Cache-Control', 'private, max-age=300'); // 5 minutes
        }

        return $response;
    }
}

