<?php

namespace App\Http\Controllers;

use App\Models\RefKeahlian;
use Illuminate\Http\Request;

class KeahlianController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = RefKeahlian::query();
        
        // Filter berdasarkan pencarian
        if ($request->has('search') && $request->search) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('nama_keahlian', 'like', "%{$search}%")
                  ->orWhere('deskripsi', 'like', "%{$search}%");
            });
        }
        
        // Filter berdasarkan status
        if ($request->has('status') && $request->status) {
            $query->where('is_active', $request->status == 'aktif');
        }
        
        $keahlianList = $query->orderBy('nama_keahlian')->paginate(10);
        
        return view('keahlian.index', compact('keahlianList'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('keahlian.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'nama_keahlian' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'is_active' => 'boolean'
        ]);

        RefKeahlian::create($validated);

        return redirect()->route('keahlian.index')
                        ->with('success', 'Data keahlian berhasil ditambahkan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(RefKeahlian $keahlian)
    {
        return view('keahlian.show', compact('keahlian'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(RefKeahlian $keahlian)
    {
        return view('keahlian.edit', compact('keahlian'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, RefKeahlian $keahlian)
    {
        $validated = $request->validate([
            'nama_keahlian' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'is_active' => 'boolean'
        ]);

        $keahlian->update($validated);

        return redirect()->route('keahlian.index')
                        ->with('success', 'Data keahlian berhasil diperbarui.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(RefKeahlian $keahlian)
    {
        $keahlian->delete();

        return redirect()->route('keahlian.index')
                        ->with('success', 'Data keahlian berhasil dihapus.');
    }
}